-----------------------------------------------------------------
-- Project: serial adder
-----------------------------------------------------------------
-- File:   SerialAdder.vhdl 
-- Author: Bernhard Wess
-- Date:   March 12, 2024
-----------------------------------------------------------------
-- 4-bit serial adder
-----------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;

entity SerialAdder is
port(
  clk   : in  std_logic;
  res_n : in  std_logic;
  start : in  std_logic;
  sa    : in  std_logic_vector(3 downto 0);
  sb    : in  std_logic_vector(3 downto 0);
  sum   : out std_logic_vector(3 downto 0);
  cy    : out std_logic;
  done  : out std_logic
  );    
end SerialAdder;

architecture rtl of SerialAdder is

-- declaration part

component fa
port(
  a  : in  std_logic;   -- data input 1  
  b  : in  std_logic;   -- data input 2  
  c  : in  std_logic;   -- data input 3  
  s  : out std_logic;   -- sum output
  co : out std_logic    -- carry out
  );    
end component;

type statetype is (s_idle, s_shift, s_done);
signal state : statetype;

signal ra : std_logic_vector(3 downto 0);
signal rb : std_logic_vector(3 downto 0);
signal rc : std_logic;

signal k : natural range 3 downto 0;

signal cs : std_logic_vector(1 downto 0);

begin -- architecture body

ufa: fa port map(
  a  => ra(0),
  b  => rb(0),
  c  => rc,
  s  => cs(0),
  co => cs(1)
  );
  
asm: process(clk,res_n)
begin
  if (res_n = '0') then
    state <= s_idle;
	rc <= '0';
  elsif (clk'event and (clk = '1')) then
    case state is
	  when s_idle =>
	    if (start = '1') then
		  state <= s_shift;
		  k <= 3;
		  ra <= sa;
		  rb <= sb;
		end if;
	  when s_shift =>
	    ra <= cs(0)&ra(3 downto 1);
		rc <= cs(1);
		rb <= rb(0)&rb(3 downto 1);
		if (k = 0) then 
		  state <= s_done;
		else
          k <= k - 1;		
		end if;
	  when s_done =>
	end case;
  end if;
end process;

  with state select
    done <= '1' when s_done,
	        '0' when others;
  sum <= ra;		
  cy <= rc;  

end rtl;