-----------------------------------------------------------------
-- Project: serial adder
-----------------------------------------------------------------
-- File:   SerialAdder_de0_cv.vhdl 
-- Author: Bernhard Wess
-- Date:   March 12, 2024
-----------------------------------------------------------------
-- de0_cv: 4-bit serial adder
-----------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;

entity SerialAdder_de0_cv is
port(
  clock_50 : in std_logic;
  SW       : in  std_logic_vector(9 downto 0);
  KEY      : in  std_logic_vector(3 downto 0);
  LEDR     : out std_logic_vector(9 downto 0)
  );    
end SerialAdder_de0_cv;

architecture structure of SerialAdder_de0_cv is

-- declaration part

component SerialAdder
port(
  clk   : in  std_logic;
  res_n : in  std_logic;
  start : in  std_logic;
  sa    : in  std_logic_vector(3 downto 0);
  sb    : in  std_logic_vector(3 downto 0);
  sum   : out std_logic_vector(3 downto 0);
  cy    : out std_logic;
  done  : out std_logic
  );    
end component;

signal start_n : std_logic;

begin -- architecture body

  start_n <= not KEY(1);

uut: SerialAdder port map(
  clk   => clock_50,
  res_n => KEY(0),
  start => start_n,
  sa    => SW(7 downto 4),
  sb    => SW(3 downto 0),
  sum   => LEDR(3 downto 0),
  cy    => LEDR(4),
  done  => LEDR(9)
  );

end structure;