-----------------------------------------------------------------
-- Project: serial adder
-----------------------------------------------------------------
-- File:   fa.vhdl 
-- Author: Bernhard Wess
-- Date:   March 12, 2024
-----------------------------------------------------------------
-- full adder
-----------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;

entity fa is
port(
  a  : in  std_logic;   -- data input 1  
  b  : in  std_logic;   -- data input 2  
  c  : in  std_logic;   -- data input 3  
  s  : out std_logic;   -- sum output
  co : out std_logic    -- carry out
  );    
end fa;

architecture structure of fa is

-- declaration part

component ha
port(
  a  : in  std_logic;   -- data input 1  
  b  : in  std_logic;   -- data input 2  
  s  : out std_logic;   -- sum output
  co : out std_logic    -- carry out
  );    
end component;

signal co1 : std_logic;
signal co2 : std_logic;
signal sa  : std_logic;

begin -- architecture body

  co <= co1 or co2;

u1: ha port map(
  a  => a,
  b  => b,
  s  => sa,
  co => co1
  );

u2: ha port map(
  a  => sa,
  b  => c,
  s  => s,
  co => co2
  );

end structure;