-----------------------------------------------------------------
-- Project: serial adder
-----------------------------------------------------------------
-- File:   fa_de0_cv.vhdl 
-- Author: Bernhard Wess
-- Date:   March 12, 2024
-----------------------------------------------------------------
-- de0_cv: full adder with output register
-----------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;

entity fa_de0_cv is
port(
  SW   : in  std_logic_vector(9 downto 0);
  KEY  : in  std_logic_vector(3 downto 0);
  LEDR : out std_logic_vector(9 downto 0)
  );    
end fa_de0_cv;

architecture structure of fa_de0_cv is

-- declaration part

component fa
port(
  a  : in  std_logic;   -- data input 1  
  b  : in  std_logic;   -- data input 2  
  c  : in  std_logic;   -- data input 3  
  s  : out std_logic;   -- sum output
  co : out std_logic    -- carry out
  );    
end component;

component reg
generic(N : natural);
port(
  clk   : in  std_logic;
  en    : in  std_logic;
  res_n : in  std_logic;
  d     : in  std_logic_vector(N-1 downto 0);
  q     : out std_logic_vector(N-1 downto 0)
  );    
end component;

signal co    : std_logic;
signal s     : std_logic;
signal dd    : std_logic_vector(1 downto 0);
signal clk_n : std_logic;

constant NN : natural := 2;

begin -- architecture body

  dd <= co&s;

u1: fa port map(
  a  => SW(2),
  b  => SW(1),
  c  => SW(0),
  s  => s,
  co => co
  );
  
u2: reg generic map(N => NN)
  port map(
    clk   => clk_n,
    en    => '1',
    res_n => KEY(1),
    d     => dd,
    q     => LEDR(NN-1 downto 0)
  );

  clk_n <= not KEY(0);

end structure;