-----------------------------------------------------------------
-- Project: serial adder
-----------------------------------------------------------------
-- File:   reg.vhdl 
-- Author: Bernhard Wess
-- Date:   March 12, 2024
-----------------------------------------------------------------
-- N-bit register
-----------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;

entity reg is
generic(N : natural);
port(
  clk   : in  std_logic;
  en    : in  std_logic;
  res_n : in  std_logic;
  d     : in  std_logic_vector(N-1 downto 0);
  q     : out std_logic_vector(N-1 downto 0)
  );    
end reg;

architecture behavior of reg is

-- declaration part

begin -- architecture body

reg2: process(clk, res_n)
  begin
    if (res_n = '0') then
	  q <= (others => '0');
	  elsif (clk'event and (clk = '1')) then
	    if (en = '1') then q <= d;
		end if;
	end if;
  end process;
  
end behavior;